/*------------------------------------------------------------------------------*
 * File Name: variant.h															*
 * Creation: DVT 1/14/2003														*
 * Purpose: Origin C header file for _VARIANT support							*
 * Copyright (c) OriginLab Corp.	2002 - 2007									*
 * All Rights Reserved															*
 *	DVT 1/14/03 QA70-3627 v7.0486 ACCESS_VARIANT_OBJECTS 						*
 *------------------------------------------------------------------------------*/

//#define _VARIANT_AS_CLASS			///	DVT 1/14/03 QA70-3627 v7.0486 ACCESS_VARIANT_OBJECTS

#ifndef _VARIANT_H
#define _VARIANT_H

// Please note: Origin C is not yet a fully implemented C++ language. Only internal
//	 classes can be declared as C++ classes. User defined C++ classes can only be
//   supported via user supplied DLLs.

/** >Composite Data Types
		This class is only available to OriginPro users.
		
		_VARIANT class represents Windows' _VARIANT structure
	
	Examples:
		#include <origin.h>
		#include <variant.h> // this file is not included in origin.h
		////////////////////////////////////////////////////////////////////////////////////
		
		void vartest()
		{
			_VARIANT varObj;
			varObj
		}
*/
class _VARIANT
{
public:
	
	/**
			Constructor for _VARIANT class. 
		Example:
			_VARIANT varObj; 					// Use constructor to create Origin C _VARIANT object
			vector<string> sv;
			
			sv.SetSize(3);
			
			sv[0] = "FirstJunk";
			sv[1] = "SecondJunk";
			sv[2] = "ThirdJunk";
			
			_VARIANT	var6;
			
			//var6 = sv[0];
			//out_int("elem var6.vt = ", var6.vt);
			//out_str((string)var6);

			var6 = sv;
			out_int("array var6.vt = ", var6.vt);
			//out_str((string)var6);
			vector<string>	sv2;
			sv2 = var6;
			
			out_str(sv2[1]);

	*/
	_VARIANT(); // Constructor for _VARIANT class.

	//_VARIANT(); // Default constructor for _VARIANT class.
	
	/**
	*/
	_VARIANT( int n ); // Constructor for _VARIANT class.

	/**
	*/
	_VARIANT( LPCSTR lpcstr ); // Constructor for _VARIANT class.

	/**
	*/
	_VARIANT( double d ); // Constructor for _VARIANT class.

	/**
	*/
	_VARIANT( _VARIANT var ); // Constructor for _VARIANT class.

	/**
			VARTYPE vt element of the MS _VARIANT structure
	*/
	USHORT	vt;

	/**
	*/
	BOOL	GetSubVariant(int index, _VARIANT &varSub);

	/*
		Makes this variant to be an (uninitialized) safearray of elements of type vtElementType.
		If lSecondDimSize is less than 1, the array is onedimensional, otherwise t is 2D.
	Paramaters:

	*/
	BOOL	CreateAsArray(USHORT vtElementType, LONG lFirstDimSize, LONG lSecondDimSize = 0,
							LONG lFirstDimLowBound = 0, LONG lSecondDimLowBound = 0);
	/**
	*/
	BOOL	SetOneVariantInArray( _VARIANT &var, LONG lFirstIndex, LONG lSecondIndex = 0 );

	//run-time error if there is no VT_ARRAY bit in vt?
	
	/**
	*/
	int		GetNumDimensions();

	/**
	*/
	int		GetSize(int nDimensionIndex = 1);	//one based dimension index

};

#endif //_VARIANT_H